package loader

import (
	"errors"
	"time"

	"code.justin.tv/feeds/distconf"
)

// Config configures the listening HTTP server ports
type Config struct {
	Interval         *distconf.Duration
	RowCount         *distconf.Int
	AudreyConnString *distconf.Str
}

// Load config from distconf
func (c *Config) Load(dconf *distconf.Distconf) error {
	c.Interval = dconf.Duration("feed-settings.loader.interval", 30*time.Minute)
	c.RowCount = dconf.Int("feed-settings.loader.row_count", 3000)
	return nil
}

// LoadSecrets configuration information
func (c *Config) LoadSecrets(dconf *distconf.Distconf) error {
	c.AudreyConnString = dconf.Str("audrey_conn_string", "")
	if c.AudreyConnString.Get() == "" {
		return errors.New("cannot find audrey_conn_string")
	}

	return nil
}
