module "feed-settings-loader" {
  source = "../modules/feed-settings-loader"
  name = "feed-settings-loader"
  hostname = "feed-settings-loader"
  owner = "garytong@twitch.tv"
  project = "feeds/feed-settings-loader"
  ami = "ami-dd11f3bd"
  instance_type = "c4.large"
  max_size = 1
  min_size = 1
  canary_size = 0
  environment = "integration"
  root_volume_size = "256"
  iam_role_name = "feed-settings-loader"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
  pagerduty_integration_url = "https://events.pagerduty.com/integration/397de4dd4fe54a15be9b2f562e5a610c/enqueue"
}

output "elb_dns_name" {
  value = "${module.feed-settings-loader.elb_dns_name}"
}

output "elb_zone_id" {
  value = "${module.feed-settings-loader.elb_zone_id}"
}

output "sns_alarm_arn" {
  value = "${module.feed-settings-loader.sns_alarm_arn}"
}
