# Service name used for AWS tagging among other things
variable "name" {}

# Service environment
variable "environment" {}

# AWS Account
variable "account" {
	default = {
		"production" = "twitch-feed-aws"
		"staging" = "twitch-feed-dev"
		"integration" = "twitch-feed-dev"
	}
}

# AWS DNS Account
variable "dns_account" {
	default = "twitch-aws"
}

# DNS Zone ID
variable "dns_zone_id" {
	default = "ZRG00SM48517Z"
}

data "terraform_remote_state" "feed-settings-loader" {
  backend = "s3"
  config {
    bucket = "${lookup(var.account, var.environment)}"
    key = "tfstate/feeds/feed-settings-loader/terraform/${var.environment}"
    region = "us-west-2"
    profile = "${lookup(var.account, var.environment)}"
  }
}

provider "aws" {
  alias = "dns"
  region = "us-west-2"
  profile = "${var.dns_account}"
}

resource "aws_route53_record" "internal_alias_record" {
  provider = "aws.dns"
  zone_id = "${var.dns_zone_id}"
  name = "${var.name}.${var.environment}.us-west2.justin.tv"
  type = "A"

  alias {
    name = "${data.terraform_remote_state.feed-settings-loader.elb_dns_name}"
    zone_id = "${data.terraform_remote_state.feed-settings-loader.elb_zone_id}"
    evaluate_target_health = true
  }
}
