resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  roles = ["${aws_iam_role.app.name}"]
}

resource "aws_iam_role_policy" "policy" {
  name = "${var.iam_role_name}_${var.environment}_policy"
  role = "${aws_iam_role.app.id}"
  depends_on = ["aws_iam_role.app"]
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${var.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}
