# Service name used for AWS tagging among other things
variable "name" {}

# DNS safe service name
variable "hostname" {}

# Domain
variable "domain" {
	default = {
		"production" = "prod.us-west2.justin.tv"
		"staging" = "dev.us-west2.justin.tv"
		"integration" = "dev.us-west2.justin.tv"
	}
}

# AWS Account
variable "account" {
	default = {
		"production" = "twitch-feed-aws"
		"staging" = "twitch-feed-dev"
		"integration" = "twitch-feed-dev"
	}
}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

variable "sandstorm_role_arn" {}

variable "pagerduty_integration_url" {}

# EC2 Instance Image
variable "ami" {
  default = "ami-dd11f3bd"
}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# Service environment
variable "environment" {}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "feed-settings-loader"
}
