module "feed-settings-loader" {
  source = "../modules/feed-settings-loader"
  name = "feed-settings-loader"
  hostname = "feed-settings-loader"
  owner = "garytong@twitch.tv"
  project = "feeds/feed-settings-loader"
  ami = "ami-dd11f3bd"
  instance_type = "c4.large"
  max_size = 6
  min_size = 3
  canary_size = 0
  environment = "production"
  root_volume_size = "256"
  iam_role_name = "feed-settings-loader"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  pagerduty_integration_url = "https://events.pagerduty.com/integration/f93f2c78329745c19f717c44693073a5/enqueue"
}

output "elb_dns_name" {
  value = "${module.feed-settings-loader.elb_dns_name}"
}

output "elb_zone_id" {
  value = "${module.feed-settings-loader.elb_zone_id}"
}

output "sns_alarm_arn" {
  value = "${module.feed-settings-loader.sns_alarm_arn}"
}
