package rollbar

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/golibs/bininfo"
	"code.justin.tv/common/golibs/errorlogger"

	"github.com/heroku/rollbar"
)

type errorLoggerImpl struct {
	rollbar rollbar.Client
}

const (
	entireStack    = 0
	truncatedStack = 7
)

// NewRollbarLogger creates a rollbar logger.
func NewRollbarLogger(token, env string) errorlogger.ErrorLogger {
	rollbar := rollbar.New(token, env, bininfo.Revision(), "", "")
	return &errorLoggerImpl{rollbar}
}

func (l *errorLoggerImpl) Error(err error) {
	l.rollbar.ErrorWithStackSkip(rollbar.ERR, err, entireStack)
}

func (l *errorLoggerImpl) RequestError(r *http.Request, err error) {
	l.rollbar.RequestErrorWithStackSkip(rollbar.ERR, r, err, entireStack)
}

func (l *errorLoggerImpl) RequestPanic(r *http.Request, p interface{}) {
	err := fmt.Errorf("panic: %v", p)
	l.rollbar.RequestErrorWithStackSkip(rollbar.ERR, r, err, truncatedStack)
}

func (l *errorLoggerImpl) Info(msg string) {
	l.rollbar.Message(rollbar.INFO, msg)
}
