package ctxlogsqs

import (
	"context"

	"code.justin.tv/feeds/ctxlog"
	"github.com/aws/aws-sdk-go/service/sqs"
)

// AttachDebugID returns a map of SQS messages attributes that embeds the debug ID if one exists
func AttachDebugID(ctx context.Context, input map[string]*sqs.MessageAttributeValue) map[string]*sqs.MessageAttributeValue {
	debugLogger := ctxlog.DebugLogger(ctx)
	if debugLogger == nil {
		return input
	}
	if input == nil {
		input = make(map[string]*sqs.MessageAttributeValue, 1)
	}
	input["X-Ctxlog-Debug"] = &sqs.MessageAttributeValue{
		StringValue: &debugLogger.DebugID,
	}
	return input
}

// ExtractDebugLogger will extract a context with a debug logger, if one exists, from a map of SQS message attributes
func ExtractDebugLogger(ctx context.Context, logger ctxlog.Logger, input map[string]*sqs.MessageAttributeValue) context.Context {
	if input == nil {
		return ctx
	}
	debugIDAttr, exists := input["X-Ctxlog-Debug"]
	if !exists {
		return ctx
	}
	if debugIDAttr.StringValue == nil {
		return ctx
	}
	return ctxlog.WithLogger(ctx, logger, *debugIDAttr.StringValue)
}
