package ctxloggoji

import (
	"math/rand"
	"time"

	"code.justin.tv/feeds/ctxlog"
	"goji.io"
)

// GojiMiddleware is usable by goji.UseC
func GojiMiddleware(Logger ctxlog.Logger) func(h goji.Handler) goji.Handler {
	return func(h goji.Handler) goji.Handler {
		return &ctxlog.CtxHandler{
			NextC:  h,
			Logger: Logger,
			IDGen:  rand.New(rand.NewSource(time.Now().UnixNano())),
		}
	}
}
