package api

import (
	"testing"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	. "github.com/smartystreets/goconvey/convey"
)

var (
	testEntity = "foo"
	testTime   = time.Now()
)

func TestModels(t *testing.T) {
	Convey("Settings", t, func() {
		Convey("#Defaults should work", func() {
			settings1 := &Settings{Entity: testEntity, CreatedAt: testTime, UpdatedAt: testTime}
			res := settings1.Defaults()
			So(res, ShouldPointTo, settings1)
			So(settings1.SubsCanComment, ShouldBeTrue)
		})
		Convey("#ApplyUpdates should work", func() {
			settings1 := &Settings{Entity: testEntity, CreatedAt: testTime, UpdatedAt: testTime}
			res := settings1.ApplyUpdates(SettingsUpdate{AdminDisabledComments: aws.Bool(true)})
			So(res, ShouldPointTo, settings1)
			So(settings1.AdminDisabledComments, ShouldBeTrue)
			res = settings1.ApplyUpdates(SettingsUpdate{AdminDisabledComments: aws.Bool(false)})
			So(res, ShouldPointTo, settings1)
			So(settings1.AdminDisabledComments, ShouldBeFalse)
		})
	})
}
