#!/bin/bash
set -ex
env
if [ -z "$AWS_CONFIG_FILE" ]; then
	CREDS="-v $HOME/.aws:/root/.aws:ro"
else
	CREDS="-e AWS_SHARED_CREDENTIALS_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro -e feed-settings_aws.assume_role=arn:aws:iam::724951484461:role/feeds-settings-integration"
fi
docker run -w /go/src/code.justin.tv/feeds/feed-settings $CREDS  -v `pwd`:/go/src/code.justin.tv/feeds/feed-settings docker.internal.justin.tv/feeds/gobuilder:1.9.2-0 make jenkins
if [ -z "$GIT_COMMIT" ]; then
  GIT_COMMIT=$(git rev-parse --verify HEAD)-$(whoami)
fi
./vendor/code.justin.tv/twitch/ecs-deploy/helpers/build-tag-push.sh feeds feed-settings $GIT_COMMIT ./cmd/feed-settings/Dockerfile
