locals {
  service = "feed-settings"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"
}

variable environment {}
variable iam_id {}
variable settings_dynamodb_arn {}

resource "aws_iam_role_policy" "sandstorm_policy" {
  name = "${local.service}_${var.environment}_sandstorm"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

// TODO: Restrict to only the correct dynamodb tables
resource "aws_iam_role_policy" "dynamodb_policy" {
  name = "${local.service}_${var.environment}_policy"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "${var.settings_dynamodb_arn}"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "sns:*"
      ],
      "Resource": [
        "*"
      ]
    }
  ]
}
EOF
}
