package distconf

import (
	"testing"
	"bytes"
)

func TestFallbackCache(t *testing.T) {
	fallback := &InMemory{}
	f := CachedReader {
		Fallback: fallback,
	}
	err := fallback.Write("testing", []byte("hello world"))
	if err != nil {
		t.Error(err)
	}
	_, err = f.Get("testing")
	if err != nil {
		t.Error(err)
	}
	buf := bytes.Buffer{}
	_, err = f.WriteTo(&buf)
	if err != nil {
		t.Error(err)
	}

	f2 := CachedReader{
		Fallback:fallback,
	}
	f2.ReadFrom(&buf)
	v, err := f2.Get("testing")
	if string(v) != "hello world" {
		t.Error("did not get hello world!")
	}
}