package manager

import (
	"errors"
	"time"

	"code.justin.tv/systems/sandstorm/testutil"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sts"
)

func createTestManager() (*Manager, error) {
	config, err := testutil.LoadTestConfig()
	if err != nil {
		return nil, err
	}
	if config == nil {
		return nil, errors.New("test config is nil")
	}

	awsConfig := &aws.Config{
		Region: aws.String(config.Sandstorm.Region),
	}
	stsclient := sts.New(session.New(awsConfig))
	arp := &stscreds.AssumeRoleProvider{
		Duration:     900 * time.Second,
		ExpiryWindow: 10 * time.Second,
		RoleARN:      config.Sandstorm.RoleArn,
		Client:       stsclient,
	}
	awsConfig.WithCredentials(credentials.NewCredentials(arp))
	return New(Config{
		AWSConfig: awsConfig,
		TableName: config.Sandstorm.TableName,
		KeyID:     config.Sandstorm.KeyID,
	}), nil
}
