package manager

import (
	"testing"

	"code.justin.tv/common/ddbmetrics"
	"code.justin.tv/systems/sandstorm/mocks"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/stretchr/testify/assert"
)

const testSecretName = "testSecretName"

type managerTest struct {
	m             *Manager
	mockDynamoDB  *mocks.DynamoDBAPI
	mockEnveloper *mocks.Enveloper
}

func (mt *managerTest) teardown(t *testing.T) {
	assert.True(t, mt.mockDynamoDB.AssertExpectations(t))
	assert.True(t, mt.mockEnveloper.AssertExpectations(t))
}

func newManagerTest(t *testing.T) *managerTest {
	noopStatter, err := statsd.NewNoopClient()
	if err != nil {
		t.Log(err)
		err = nil
	}

	ddb := new(mocks.DynamoDBAPI)
	ddbMetrics := ddbmetrics.New(new(dynamodb.DynamoDB), noopStatter)
	ddbMetrics.Start()

	env := new(mocks.Enveloper)
	m := &Manager{
		Envelope: env,
		DynamoDB: ddb,
		metrics:  ddbMetrics,
	}
	return &managerTest{
		m:             m,
		mockDynamoDB:  ddb,
		mockEnveloper: env,
	}
}

func createMocks(t *testing.T) (*Manager, *mocks.DynamoDBAPI, *mocks.Enveloper) {
	mt := newManagerTest(t)
	return mt.m, mt.mockDynamoDB, mt.mockEnveloper
}
