locals {
  team    = "feeds"
  service = "feeds-edge"
}

provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/feeds-edge-service.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "pipeline" {
  source         = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//promotion_pipeline?ref=v0.8.20"
  team           = "${local.team}"
  service        = "${local.service}"
  git_repository = "https://git-aws.internal.justin.tv/${local.team}/${local.service}"
}
