locals {
  service = "feeds-edge"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"
}

variable "environment" {}
variable iam_id {}
variable sqs_policy_arn {}

resource "aws_iam_policy" "sandstorm_assume_role" {
  name = "sandstorm_policy_${local.service}_${var.environment}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "sandstorm_attach_policy" {
  role       = "${var.iam_id}"
  policy_arn = "${aws_iam_policy.sandstorm_assume_role.arn}"
}

resource "aws_iam_role_policy_attachment" "hard_delete_user_permissions" {
  role       = "${var.iam_id}"
  policy_arn = "${var.sqs_policy_arn}"
}
