# Twitch Chat Badges Service

#### Links
[Product Spec](https://docs.google.com/document/d/1x2LfUcY0491F5LAD7hpjbZbWoIcM4L1RuulL2Ih0Vzw)   
[Tech Spec](https://docs.google.com/document/d/1Arb48jV8rI2jEho9rg15vzMvrsRBKLuVIIm3I1Q9VYo)   
[Grafana](https://grafana.internal.justin.tv/dashboard/db/badges-health)   
[Rollbar](https://rollbar.com/Twitch/badges/items/)   

#### API
[Product Spec](https://docs.google.com/document/d/1x2LfUcY0491F5LAD7hpjbZbWoIcM4L1RuulL2Ih0Vzw)   

#### Hosts
* Production External: `badges.twitch.tv`
* Production Internal: `badges.internal.twitch.tv`
* Staging External: `badges-staging.twitch.tv`
* Staging Internal: `badges-staging.internal.twitch.tv`

#### Integration

    import "code.justin.tv/chat/badges/client"

#### Local Development
First, install Go

    brew install go --cross-compile-common

Now set up your $GOPATH

    mkdir $HOME/go
    export GOPATH=$HOME/go

Download the repo into it

    go get -d code.justin.tv/chat/badges
    cd ~/go/src/code.justin.tv/chat/badges

Install Foreman:

    gem install foreman
    
Run Tests:

    make test

Run Foreman for Badges:

    foreman start
    
