freeStyleJob('chat-badges') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'chat/badges', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'chat/badges', '.manta'
  }
}

freeStyleJob('chat-badges-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo chat/badges --dir /opt/twitch/badges'
  }
}
 