package emoticons

import (
	"reflect"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"

	"code.justin.tv/chat/rails"
)

func TestFetch(t *testing.T) {
	resp := rails.EmoticonsResp{
		EmoticonSets: map[string][]rails.Emoticon{
			"1": {},
			"2": {
				rails.Emoticon{Id: 20, Pattern: "Twenty"},
			},
			"3": {
				rails.Emoticon{Id: 30, Pattern: "Thirty"},
				rails.Emoticon{Id: 300, Pattern: "ThreeHundred"},
			},
		},
	}

	rm := &rails.MockRails{}
	rm.On("AllEmoticons", mock.Anything, mock.Anything).Return(&resp, nil)

	fetcher := NewFetcherFromRails(rm)
	lex, _, err := fetcher.Fetch(context.Background())
	assert.Nil(t, err)
	expected := &Lexicon{
		1: {},
		2: {
			Emoticon{ID: 20, Pattern: "Twenty"},
		},
		3: {
			Emoticon{ID: 30, Pattern: "Thirty"},
			Emoticon{ID: 300, Pattern: "ThreeHundred"},
		},
	}
	assert.True(t, reflect.DeepEqual(lex, expected))
}
