package responses

import "code.justin.tv/web/cohesion/client/v2"

type FriendStatusResponse struct {
	Status string `json:"status"`
}

type FriendListResponse struct {
	Friends []*v2.AssocResponse `json:"friends"`
	Cursor  string              `json:"cursor"`
	Total   uint                `json:"total"`
}

type FriendRequestListResponse struct {
	Requests      []*v2.AssocResponse `json:"requests"`
	Strangers     []*v2.AssocResponse `json:"stranger_requests"`
	NonStrangers  []*v2.AssocResponse `json:"nonstranger_requests"`
	IteratorToken string              `json:"iterator_token"`
	Cursor        string              `json:"cursor"`
	Total         uint                `json:"total"`
}

type NotificationsCountResponse struct {
	Count uint `json:"count"`
}

type RecommendedFriendsResponseV0 struct {
	RecommendedIDs []int64 `json:"recommended"`
	Source         string  `json:"source"`
}

type RecommendedFriendsResponseV1 struct {
	RecommendedFriends []RecommendedFriendV1 `json:"recommended"`
	Source             string                `json:"source"`
}

type RecommendedFriendV1 struct {
	UserID string `json:"user_id"`
	Reason string `json:"reason"`
}

type IsFamiliarResponse struct {
	Reason     string `json:"reason"`
	IsFamiliar bool   `json:"is_familiar"`
}
