package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) getFriendshipV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id", "friend_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0]
	targetID := params[1]

	resp, err := s.backend.GetFriendship(ctx, targetID, sourceID)
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	respMap := responses.FriendStatusResponse{Status: resp}
	gojiplus.ServeJSON(w, r, respMap)
}

func (s *Server) isFriendV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id", "target_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0]
	targetID := params[1]

	if isFriend, err := s.backend.IsFriend(ctx, targetID, sourceID); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	} else if !isFriend {
		w.WriteHeader(http.StatusNotFound)
		return
	}

	w.WriteHeader(http.StatusOK)
}
