package api

import (
	"fmt"
	"testing"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"

	. "github.com/smartystreets/goconvey/convey"
)

func TestGetFriendship(t *testing.T) {
	var server *Server
	var b *backend.Backend
	Convey("When finding friendship status", t, func() {
		server, b = serverWithTestBackend()
		mockFriends := b.Friends.(*backendtest.CohesionClient)
		So(len(mockFriends.GetCalls()), ShouldEqual, 0)

		Convey("should call the appropriate Cohesion functions", func() {
			path := fmt.Sprintf("/users/%s/friends/%s", backend.AliceID, backend.BobID)

			doTestHTTP(server, "GET", path)
			So(len(mockFriends.GetCalls()), ShouldEqual, 1)

			fetchCall := mockFriends.GetCalls()[0]
			expected := backendtest.Call{
				Name: "Associations",
				E1:   backend.AliceID,
				E2:   backend.BobID,
			}
			validateCall(fetchCall, expected)
		})
	})
}

func TestIsFriend(t *testing.T) {
	var server *Server
	var b *backend.Backend
	Convey("Checking if 2 users are friends", t, func() {
		server, b = serverWithTestBackend()
		mockFriends := b.Friends.(*backendtest.CohesionClient)
		So(len(mockFriends.GetCalls()), ShouldEqual, 0)

		Convey("should call the appropriate Cohesion functions", func() {
			path := fmt.Sprintf("/v1/users/%s/friends/%s/friend", backend.AliceID, backend.BobID)

			doTestHTTP(server, "GET", path)
			So(len(mockFriends.GetCalls()), ShouldEqual, 1)

			fetchCall := mockFriends.GetCalls()[0]
			expected := backendtest.Call{
				Name: "FetchAssoc",
				Kind: "friends_with",
				E1:   backend.AliceID,
				E2:   backend.BobID,
			}
			validateCall(fetchCall, expected)
		})
	})
}
