package friendship

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/common/twitchhttp"
)

func (c *clientImpl) AcceptRequest(ctx context.Context, userID, requesterID string, reqOpts *twitchhttp.ReqOpts) error {
	path := fmt.Sprintf("/v1/users/%s/friends/%s", userID, requesterID)
	req, err := c.NewRequest("PUT", path, nil)
	if err != nil {
		return err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.friendship.accept_request",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusNoContent {
		return twitchhttp.HandleFailedResponse(resp)
	}

	return nil
}
