package friendship

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/common/twitchhttp"
)

func (c *clientImpl) DismissRecommendation(ctx context.Context, userID, targetID string, reqOpts *twitchhttp.ReqOpts) error {
	path := fmt.Sprintf("/users/%s/friends/recommended/%s", userID, targetID)
	req, err := c.NewRequest("DELETE", path, nil)
	if err != nil {
		return err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.friendship.dismiss_recommendation",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusOK {
		return twitchhttp.HandleFailedResponse(resp)
	}

	return nil
}
