package friendship

import (
	"fmt"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/common/twitchhttp"
)

func (c *clientImpl) GetNotificationCount(ctx context.Context, userID string, reqOpts *twitchhttp.ReqOpts) (uint, error) {
	path := fmt.Sprintf("/v1/users/%s/friends/notifications/count", userID)
	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return 0, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.friendship.get_notifications_count",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	var decoded responses.NotificationsCountResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return 0, err
	}
	return decoded.Count, nil
}
