package friendship

import (
	"fmt"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/common/twitchhttp"
)

func (c *clientImpl) GetRecommendedFriends(ctx context.Context, userID string, reqOpts *twitchhttp.ReqOpts) (*responses.RecommendedFriendsResponseV1, error) {
	path := fmt.Sprintf("/v1/users/%s/friends/recommended", userID)
	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return nil, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.friendship.get_recommended_friends",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	var decoded responses.RecommendedFriendsResponseV1
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return nil, err
	}
	return &decoded, nil
}
