package friendship

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/common/twitchhttp"
)

type RequestParams struct {
	UserID        string
	TargetID      string
	IsRecommended bool
}

func (c *clientImpl) Request(ctx context.Context, params RequestParams, reqOpts *twitchhttp.ReqOpts) error {
	path := fmt.Sprintf("/v1/users/%s/friends/%s?is_recommended=%t", params.UserID, params.TargetID, params.IsRecommended)

	req, err := c.NewRequest("POST", path, nil)
	if err != nil {
		return err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.friendship.request_friend",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusNoContent {
		return twitchhttp.HandleFailedResponse(resp)
	}

	return nil
}
