package friendship

const (
	RequestFriendEvent       = "request_friend"
	AcceptFriendRequestEvent = "accept_friend_request"
	RejectFriendRequestEvent = "reject_friend_request"
	CancelFriendRequestEvent = "cancel_friend_request"
	RemoveFriendEvent        = "remove_friend"
)

type RequestFriendPayload struct {
	UserID        string `json:"user_id"`
	TargetUserID  string `json:"target_user_id"`
	IsRecommended bool   `json:"is_recommended"`
}

type AcceptFriendRequestPayload struct {
	UserID       string `json:"user_id"`
	TargetUserID string `json:"target_user_id"`
}

type RejectFriendRequestPayload struct {
	UserID       string `json:"user_id"`
	TargetUserID string `json:"target_user_id"`
}

type CancelFriendRequestPayload struct {
	UserID       string `json:"user_id"`
	TargetUserID string `json:"target_user_id"`
}

type RemoveFriendPayload struct {
	UserID       string `json:"user_id"`
	TargetUserID string `json:"target_user_id"`
}
