package leviathan

import (
	"testing"
)

func TestReasonsForReportType(t *testing.T) {
	reasons, err := ReasonsForReportType(userReport)
	if err != nil {
		t.Errorf("Failed creating client: %v", err)
		t.FailNow()
	}
	if len(reasons) == 0 {
		t.Error("Failed getting reasons for `user` report type")
	}
	for _, reason := range reasons {
		if reason.ID == "" {
			t.Error("Reason without an id")
		}
		if reason.Display["en"] != englishReasons[reason.ID] {
			t.Error("Reason with incorrect english display string")
		}
	}

	reasons, err = ReasonsForReportType("doesntexist")
	if reasons != nil {
		t.Error("Errornously retrieved reasons for non existent report type")
	}
	if err == nil {
		t.Error("No error returned when requesting reasons for non existent report type")
	}
}
