package leviathan

// As a step towards forward thinking, we want to be able to query the
// valid s for a report based on the report type. The hardcoded
// values in this file move the hardcoding out of the user side clients.
//
// In the future when leviathan is replaced the reason will come from it
// and the client will be updated to call an endpoint on the leviathan
// replacement, but that will end up transparent to the user side clients

// List of types of reports (what the user is reporting)
const (
	userReport               = "user_report"
	vodReport                = "vod_report"
	vodCommentReport         = "vod_comment_report"
	clipReport               = "clip_report"
	communityReport          = "community_report"
	collectionReport         = "collection_report"
	whisperReport            = "whisper_report"
	eventReport              = "event_report"
	extensionReport          = "extension_report"
	channelFeedPostReport    = "channel_feed_post_report"
	channelFeedCommentReport = "channel_feed_comment_report"
	curseWhisperReport       = "curse_whisper"
	cursePrivateGroupReport  = "curse_private_group"
	cursePublicGroupReport   = "curse_public_group"
	chatReport               = "chat_report"
)

// List of reasons for a report
const (
	tosBanEvasion         = "tos_ban_evasion"
	chatBanEvasion        = "chat_ban_evasion"
	selfHarm              = "selfharm"
	harm                  = "harm"
	harassment            = "harassment"
	hateSpeech            = "hate_speech"
	offensiveUsername     = "offensive_username"
	impersonation         = "impersonation"
	spam                  = "spam"
	porn                  = "porn"
	nudity                = "nudity"
	gore                  = "gore"
	underaged             = "underaged"
	cheating              = "cheating"
	prohibited            = "prohibited"
	miscategorized        = "miscategorized"
	bitsViolation         = "bits_violation"
	communityTosViolation = "community_tos_violation"
	other                 = "other"
)

var (
	reportReasonMatrix = map[string][]string{
		userReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			cheating,
			prohibited,
			miscategorized,
			bitsViolation,
			communityTosViolation,
			other,
		},
		vodReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			cheating,
			prohibited,
			miscategorized,
			bitsViolation,
			other,
		},
		vodCommentReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
		extensionReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			cheating,
			prohibited,
			bitsViolation,
			other,
		},
		clipReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			cheating,
			prohibited,
			miscategorized,
			bitsViolation,
			other,
		},
		communityReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			cheating,
			prohibited,
			bitsViolation,
			other,
		},
		collectionReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			prohibited,
			bitsViolation,
			other,
		},
		eventReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			cheating,
			prohibited,
			bitsViolation,
			other,
		},
		channelFeedPostReport: {
			tosBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			cheating,
			prohibited,
			bitsViolation,
			other,
		},
		channelFeedCommentReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
		whisperReport: {
			harassment,
			spam,
			other,
		},
		curseWhisperReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
		cursePrivateGroupReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
		cursePublicGroupReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
		chatReport: {
			tosBanEvasion,
			chatBanEvasion,
			selfHarm,
			harm,
			harassment,
			hateSpeech,
			offensiveUsername,
			impersonation,
			spam,
			porn,
			nudity,
			gore,
			underaged,
			bitsViolation,
			other,
		},
	}
)
