package leviathan

// The tests in this file are no less hardcoded than `reports.go` but
// transpose the matrix, as an extra level of validation.

import (
	"testing"
)

func validate(t *testing.T, reason, reportType string) {
	s, ok := reportReasonMatrix[reportType]
	if !ok {
		t.Errorf("Unable to find report type `%s`", reportType)
		return
	}
	for _, r := range s {
		if r == reason {
			return
		}
	}
	t.Errorf("Unable to find `%s` in report type %s", reason, reportType)
}

func TestTosBanEvasion(t *testing.T) {
	validate(t, tosBanEvasion, userReport)
	validate(t, tosBanEvasion, vodReport)
	validate(t, tosBanEvasion, vodCommentReport)
	validate(t, tosBanEvasion, clipReport)
	validate(t, tosBanEvasion, communityReport)
	validate(t, tosBanEvasion, collectionReport)
	validate(t, tosBanEvasion, eventReport)
	validate(t, tosBanEvasion, extensionReport)
	validate(t, tosBanEvasion, channelFeedPostReport)
	validate(t, tosBanEvasion, channelFeedCommentReport)
	validate(t, tosBanEvasion, curseWhisperReport)
	validate(t, tosBanEvasion, cursePrivateGroupReport)
	validate(t, tosBanEvasion, cursePublicGroupReport)
	validate(t, tosBanEvasion, chatReport)
}

func TestChatBanEvasion(t *testing.T) {
	validate(t, chatBanEvasion, userReport)
	validate(t, chatBanEvasion, vodCommentReport)
	validate(t, chatBanEvasion, channelFeedCommentReport)
	validate(t, chatBanEvasion, curseWhisperReport)
	validate(t, chatBanEvasion, cursePrivateGroupReport)
	validate(t, chatBanEvasion, cursePublicGroupReport)
	validate(t, chatBanEvasion, chatReport)
}

func TestSelfHarm(t *testing.T) {
	validate(t, selfHarm, userReport)
	validate(t, selfHarm, vodReport)
	validate(t, selfHarm, vodCommentReport)
	validate(t, selfHarm, clipReport)
	validate(t, selfHarm, communityReport)
	validate(t, selfHarm, collectionReport)
	validate(t, selfHarm, eventReport)
	validate(t, selfHarm, extensionReport)
	validate(t, selfHarm, channelFeedPostReport)
	validate(t, selfHarm, channelFeedCommentReport)
	validate(t, selfHarm, curseWhisperReport)
	validate(t, selfHarm, cursePrivateGroupReport)
	validate(t, selfHarm, cursePublicGroupReport)
	validate(t, selfHarm, chatReport)
}

func TestHarm(t *testing.T) {
	validate(t, harm, userReport)
	validate(t, harm, vodReport)
	validate(t, harm, vodCommentReport)
	validate(t, harm, clipReport)
	validate(t, harm, communityReport)
	validate(t, harm, collectionReport)
	validate(t, harm, eventReport)
	validate(t, harm, extensionReport)
	validate(t, harm, channelFeedPostReport)
	validate(t, harm, channelFeedCommentReport)
	validate(t, harm, curseWhisperReport)
	validate(t, harm, cursePrivateGroupReport)
	validate(t, harm, cursePublicGroupReport)
	validate(t, harm, chatReport)
}

func TestHarassment(t *testing.T) {
	validate(t, harassment, userReport)
	validate(t, harassment, vodReport)
	validate(t, harassment, vodCommentReport)
	validate(t, harassment, clipReport)
	validate(t, harassment, communityReport)
	validate(t, harassment, collectionReport)
	validate(t, harassment, whisperReport)
	validate(t, harassment, eventReport)
	validate(t, harassment, extensionReport)
	validate(t, harassment, channelFeedPostReport)
	validate(t, harassment, channelFeedCommentReport)
	validate(t, harassment, curseWhisperReport)
	validate(t, harassment, cursePrivateGroupReport)
	validate(t, harassment, cursePublicGroupReport)
	validate(t, harassment, chatReport)
}

func TestHateSpeech(t *testing.T) {
	validate(t, hateSpeech, userReport)
	validate(t, hateSpeech, vodReport)
	validate(t, hateSpeech, vodCommentReport)
	validate(t, hateSpeech, clipReport)
	validate(t, hateSpeech, communityReport)
	validate(t, hateSpeech, collectionReport)
	validate(t, hateSpeech, eventReport)
	validate(t, hateSpeech, extensionReport)
	validate(t, hateSpeech, channelFeedPostReport)
	validate(t, hateSpeech, channelFeedCommentReport)
	validate(t, hateSpeech, curseWhisperReport)
	validate(t, hateSpeech, cursePrivateGroupReport)
	validate(t, hateSpeech, cursePublicGroupReport)
	validate(t, hateSpeech, chatReport)
}

func TestOffensiveUsername(t *testing.T) {
	validate(t, offensiveUsername, userReport)
	validate(t, offensiveUsername, vodCommentReport)
	validate(t, offensiveUsername, channelFeedCommentReport)
	validate(t, offensiveUsername, curseWhisperReport)
	validate(t, offensiveUsername, cursePrivateGroupReport)
	validate(t, offensiveUsername, cursePublicGroupReport)
	validate(t, offensiveUsername, chatReport)
}

func TestImpersonation(t *testing.T) {
	validate(t, impersonation, userReport)
	validate(t, impersonation, vodReport)
	validate(t, impersonation, vodCommentReport)
	validate(t, impersonation, clipReport)
	validate(t, impersonation, communityReport)
	validate(t, impersonation, collectionReport)
	validate(t, impersonation, eventReport)
	validate(t, impersonation, extensionReport)
	validate(t, impersonation, channelFeedPostReport)
	validate(t, impersonation, channelFeedCommentReport)
	validate(t, impersonation, curseWhisperReport)
	validate(t, impersonation, cursePrivateGroupReport)
	validate(t, impersonation, cursePublicGroupReport)
	validate(t, impersonation, chatReport)
}

func TestSpam(t *testing.T) {
	validate(t, spam, userReport)
	validate(t, spam, vodReport)
	validate(t, spam, vodCommentReport)
	validate(t, spam, clipReport)
	validate(t, spam, communityReport)
	validate(t, spam, collectionReport)
	validate(t, spam, whisperReport)
	validate(t, spam, eventReport)
	validate(t, spam, extensionReport)
	validate(t, spam, channelFeedPostReport)
	validate(t, spam, channelFeedCommentReport)
	validate(t, spam, curseWhisperReport)
	validate(t, spam, cursePrivateGroupReport)
	validate(t, spam, cursePublicGroupReport)
	validate(t, spam, chatReport)
}

func TestPorn(t *testing.T) {
	validate(t, porn, userReport)
	validate(t, porn, vodReport)
	validate(t, porn, vodCommentReport)
	validate(t, porn, clipReport)
	validate(t, porn, communityReport)
	validate(t, porn, collectionReport)
	validate(t, porn, eventReport)
	validate(t, porn, extensionReport)
	validate(t, porn, channelFeedPostReport)
	validate(t, porn, channelFeedCommentReport)
	validate(t, porn, curseWhisperReport)
	validate(t, porn, cursePrivateGroupReport)
	validate(t, porn, cursePublicGroupReport)
	validate(t, porn, chatReport)
}

func TestNudity(t *testing.T) {
	validate(t, nudity, userReport)
	validate(t, nudity, vodReport)
	validate(t, nudity, vodCommentReport)
	validate(t, nudity, clipReport)
	validate(t, nudity, communityReport)
	validate(t, nudity, collectionReport)
	validate(t, nudity, eventReport)
	validate(t, nudity, extensionReport)
	validate(t, nudity, channelFeedPostReport)
	validate(t, nudity, channelFeedCommentReport)
	validate(t, nudity, curseWhisperReport)
	validate(t, nudity, cursePrivateGroupReport)
	validate(t, nudity, cursePublicGroupReport)
	validate(t, nudity, chatReport)
}

func TestGore(t *testing.T) {
	validate(t, gore, userReport)
	validate(t, gore, vodReport)
	validate(t, gore, vodCommentReport)
	validate(t, gore, clipReport)
	validate(t, gore, communityReport)
	validate(t, gore, collectionReport)
	validate(t, gore, eventReport)
	validate(t, gore, extensionReport)
	validate(t, gore, channelFeedPostReport)
	validate(t, gore, channelFeedCommentReport)
	validate(t, gore, curseWhisperReport)
	validate(t, gore, cursePrivateGroupReport)
	validate(t, gore, cursePublicGroupReport)
	validate(t, gore, chatReport)
}

func TestUnderaged(t *testing.T) {
	validate(t, underaged, userReport)
	validate(t, underaged, vodReport)
	validate(t, underaged, vodCommentReport)
	validate(t, underaged, clipReport)
	validate(t, underaged, channelFeedPostReport)
	validate(t, underaged, channelFeedCommentReport)
	validate(t, underaged, curseWhisperReport)
	validate(t, underaged, cursePrivateGroupReport)
	validate(t, underaged, cursePublicGroupReport)
	validate(t, underaged, chatReport)
}

func TestCheating(t *testing.T) {
	validate(t, cheating, userReport)
	validate(t, cheating, vodReport)
	validate(t, cheating, clipReport)
	validate(t, cheating, communityReport)
	validate(t, cheating, eventReport)
	validate(t, cheating, extensionReport)
	validate(t, cheating, channelFeedPostReport)
}

func TestProhibited(t *testing.T) {
	validate(t, prohibited, userReport)
	validate(t, prohibited, vodReport)
	validate(t, prohibited, clipReport)
	validate(t, prohibited, communityReport)
	validate(t, prohibited, eventReport)
	validate(t, prohibited, extensionReport)
	validate(t, prohibited, channelFeedPostReport)
}

func TestMiscategorized(t *testing.T) {
	validate(t, miscategorized, userReport)
	validate(t, miscategorized, clipReport)
	validate(t, miscategorized, vodReport)
}

func TestBitsViolation(t *testing.T) {
	validate(t, bitsViolation, userReport)
	validate(t, bitsViolation, vodReport)
	validate(t, bitsViolation, vodCommentReport)
	validate(t, bitsViolation, clipReport)
	validate(t, bitsViolation, communityReport)
	validate(t, bitsViolation, collectionReport)
	validate(t, bitsViolation, eventReport)
	validate(t, bitsViolation, extensionReport)
	validate(t, bitsViolation, channelFeedPostReport)
	validate(t, bitsViolation, channelFeedCommentReport)
	validate(t, bitsViolation, curseWhisperReport)
	validate(t, bitsViolation, cursePrivateGroupReport)
	validate(t, bitsViolation, cursePublicGroupReport)
	validate(t, bitsViolation, chatReport)
}

func TestCommunityTosViolation(t *testing.T) {
	validate(t, communityTosViolation, userReport)
}

// Test that every report type has other as a valid reason
func TestAllhaveOther(t *testing.T) {
Tests:
	for report, s := range reportReasonMatrix {
		for _, reason := range s {
			if reason == other {
				continue Tests
			}
		}
		t.Errorf("Unable to find `other` in report type %s", report)
	}
}
