job {
    name "chat-leviathan"
    using 'TEMPLATE-autobuild'
    logRotator {
        daysToKeep(14)
    }
    scm {
        git {
            remote {
                github 'chat/leviathan', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            //shallowClone true
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell "manta -v -proxy"
        saveDeployArtifact 'chat/leviathan', '.manta'
    }
    throttleConcurrentBuilds {
      maxPerNode 2
    }
    wrappers {
      colorizeOutput(colorMap = 'xterm')
    }

}

job {
  name 'chat-leviathan-deploy'
  using 'TEMPLATE-deploy'

  logRotator {
    daysToKeep(14)
  }
  parameters {
    booleanParam('TRIGGER_SMOCA', false)
    stringParam('GITHUB_CREATOR', '')
  }
  steps {
      environmentVariables {
          envs([
              'LC_ALL': 'en_US.UTF-8',
              'LANG': 'en_US.UTF-8'
          ])
      }
      downloadDeployArtifact "chat/leviathan"
      shell 'update-deployed-version -repo chat/leviathan'
      shell 'courier deploy --repo chat/leviathan --dir /opt/twitch/leviathan'
      shell "courier/post-deploy.sh"
      shell 'update-deployed-version -repo chat/leviathan -known-good'

      // Run Smoca downstream if TRIGGER_SMOCA is true
      conditionalSteps {
        condition {
          booleanCondition('$TRIGGER_SMOCA')
        }
        runner('Fail')
        steps {
          downstreamParameterized {
            trigger('qa-smoca') {
              parameters {
                currentBuild()
              }
            }
          }
        }
      }
  }
}
