package rails

import "github.com/stretchr/testify/mock"
import "time"
import "golang.org/x/net/context"
import "code.justin.tv/common/twitchhttp"

// MockRails is an autogenerated mock type for the Rails type
type MockRails struct {
	mock.Mock
}

// AllEmoticons provides a mock function with given fields: ctx, reqOpts
func (_m *MockRails) AllEmoticons(ctx context.Context, reqOpts *twitchhttp.ReqOpts) (*EmoticonsResp, error) {
	ret := _m.Called(ctx, reqOpts)

	var r0 *EmoticonsResp
	if rf, ok := ret.Get(0).(func(context.Context, *twitchhttp.ReqOpts) *EmoticonsResp); ok {
		r0 = rf(ctx, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*EmoticonsResp)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AreStreamUpEmailsDisabled provides a mock function with given fields: ctx, userID, reqOpts
func (_m *MockRails) AreStreamUpEmailsDisabled(ctx context.Context, userID int, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, userID, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, int, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, userID, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, userID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// FacebookConnected provides a mock function with given fields: ctx, userName, reqOpts
func (_m *MockRails) FacebookConnected(ctx context.Context, userName string, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, userName, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, userName, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, userName, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IsFamiliar provides a mock function with given fields: ctx, fromUserId, toUserId, reqOpts
func (_m *MockRails) IsFamiliar(ctx context.Context, fromUserId int, toUserId int, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, fromUserId, toUserId, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, int, int, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, fromUserId, toUserId, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, int, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, fromUserId, toUserId, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TriggerCommercial provides a mock function with given fields: ctx, channelName, length, reqOpts
func (_m *MockRails) TriggerCommercial(ctx context.Context, channelName string, length time.Duration, reqOpts *twitchhttp.ReqOpts) (time.Duration, error) {
	ret := _m.Called(ctx, channelName, length, reqOpts)

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func(context.Context, string, time.Duration, *twitchhttp.ReqOpts) time.Duration); ok {
		r0 = rf(ctx, channelName, length, reqOpts)
	} else {
		r0 = ret.Get(0).(time.Duration)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, time.Duration, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, channelName, length, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
