package rails

import (
	"fmt"
	"testing"

	"code.justin.tv/common/twitchhttp"
	"golang.org/x/net/context"
)

func TestAreStreamUpEmailsDisabled(t *testing.T) {
	conf := twitchhttp.ClientConf{
		Host: "api.internal.twitch.tv",
	}
	client, err := New(conf, "test")
	if err != nil {
		fmt.Println(err.Error())
		t.Fail()
	}

	// account 1: all emails disabled
	expect := true
	resp, err := client.AreStreamUpEmailsDisabled(context.Background(), 127999146, &twitchhttp.ReqOpts{})
	if err != nil {
		fmt.Println(err.Error())
		t.Fail()
	}
	if resp != expect {
		fmt.Println(fmt.Sprintf("Expected %v, got %v", expect, resp))
		t.Fail()
	}

	// account 2: stream up emails disabled
	expect = true
	resp, err = client.AreStreamUpEmailsDisabled(context.Background(), 127999228, &twitchhttp.ReqOpts{})
	if err != nil {
		fmt.Println(err.Error())
		t.Fail()
	}
	if resp != expect {
		fmt.Println(fmt.Sprintf("Expected %v, got %v", expect, resp))
		t.Fail()
	}

	// account 3: all emails enabled
	expect = false
	resp, err = client.AreStreamUpEmailsDisabled(context.Background(), 127999287, &twitchhttp.ReqOpts{})
	if err != nil {
		fmt.Println(err.Error())
		t.Fail()
	}
	if resp != expect {
		fmt.Println(fmt.Sprintf("Expected %v, got %v", expect, resp))
		t.Fail()
	}
}
