[![codecov](https://codecov.internal.justin.tv/ghe/chat/tmi/branch/master/graph/badge.svg)](https://codecov.internal.justin.tv/ghe/chat/tmi)

Contributing to TMI
===
We encourage other teams to contribute to our projects!

If you would like to submit a bugfix, please submit a Pull Request (PR) which includes a link to a phabricator CR. You can either send the request from a forked repository or from a branch on TMI if you have access.

If you wish to contribute new functionality, please message us in the [#chat-and-messaging](https://twitch.slack.com/messages/chat-and-messaging) slack room so we can discuss any proposed changes before any code is submitted.  After this discussion and you've implemented the new functionality, please submit a PR which includes a link to a phabricator CR.

Thanks in advance for your contributions!

### Other Docs
- [HTTP Edge API Spec](docs/http_edge_api.md)

#### Forcing Specific Chat Environments

Darklaunch (irc-ws-darklaunch.chat.twitch.tv):

    https://www.twitch.tv/iretest?tmi_host=irc-ws-darklaunch.chat.twitch.tv&tmi_port=443&tmi_log_level=debug?tmi_secure=true

Must allow insecure scripts in URL bar.

Staging (irc-ws-staging.internal.twitch.tv):

    https://www.twitch.tv/iretest?tmi_host=irc-ws-staging.internal.twitch.tv&tmi_port=443&tmi_log_level=debug?tmi_secure=true

Must allow insecure scripts in URL bar.

TMI Development
===

Notes: You should consider adding your go environment variables to your ~/.profile

#### Project Setup

Download and install Go: https://golang.org/doc/install

    $ export GOPATH=$HOME/go
    $ export PATH=$PATH:$GOPATH/bin

You should consider adding these to your ~/.profile

    $ mkdir -p $GOPATH/src/code.justin.tv/chat
    $ git clone git@git-aws.internal.justin.tv:chat/tmi.git $GOPATH/src/code.justin.tv/chat/tmi
    $ cd $GOPATH/src/code.justin.tv/chat/tmi

#### Installing dependencies

All dependencies can be installed with:

    $ make setup

#### Compiling

    $ make go

#### Testing

Run all integration tests:

    $ make test

Single Test (eg. test clue)

    $ make test_clue

Some of the tests require that redis is listening on port 6379, so you may need to start redis in the background first:

    $ redis-server &

#### Go dependencies

##### Modify a dependency version

  1. Open glide.yaml
  2. Find the package you want to change and update the version
  3. `make glide`
  4. Commit changes to `glide.yaml`, `glide.lock`, and `vendor`

##### Adding a dependency

  1. Open glide.yaml
  2. Add the package and version
  3. `make glide`
  4. Commit changes to `glide.yaml`, `glide.lock`, and `vendor`

#### Local sandstorm

Install sandstorm:

    $ go get -u code.justin.tv/systems/sandstorm-agent

Run sandstorm-agent from the root (chat/tmi) directory:

    $ make sandstorm

This will generate `clue.json` in your local_conf folder w/ secrets.

If this fails with a `NoCredentialProviders: no valid providers in chain` error,
make sure you've either set `twitch-chat-aws` as your default aws cli profile, or prepend the command with `AWS_PROFILE=twitch-chat-aws`


#### Running locally

Start redis in background:

    $ redis-server &

Start foreman:

    $ foreman start

If you don't have foreman, you can install it like so:

    $ sudo gem install foreman

If this blows up with an error about the cohesion client not being able to find `chat.json`, make sure you've actually got `web/cohesion`
at the vendored version in your `$GOPATH`

TMI should be running locally on your machine. You can interact with it in several ways.

##### Making HTTP calls
Make HTTP calls to your localhost:(port #) by command line (e.g. [cURL](http://curl.haxx.se/docs/manpage.html)) or GUI (e.g. Google Chrome extension  [Postman](https://chrome.google.com/webstore/detail/postman-rest-client/fdmmgilgnpjigdojojpjoooidkmcomcm?hl=en)).

##### Connect via Netcat (use wscat for websockets)
Open a TCP/UDP connection:

    $ nc localhost 6800

Open a websocket connection:

    $ wscat -c 'localhost:6800'

Get your password from http://twitchapps.com/tmi/ and then log in with:

    pass oauth:asfasdfasdfasdf
    nick username

Enable replies with:

    CAP REQ twitch.tv/commands
    CAP REQ twitch.tv/tags

##### Connect via web
Go to your favorite channel page with the tmi_host and tmi_port url parameters set:

    http://www.twitch.tv/iretest?tmi_host=localhost.twitch.tv&tmi_port=6800&tmi_log_level=debug

Note that you'll need to have an entry in your /etc/hosts file like so:

    127.0.0.1   localhost.twitch.tv

This is necessary because our javascript only connects to domains ending in `*.twitch.tv` or `*.justin.tv`

To connect to darklaunch, point your browser to:

    https://www.twitch.tv/iretest?tmi_host=irc-ws-darklaunch.chat.twitch.tv&tmi_port=443&tmi_log_level=debug


To get started (Linux) (Untested)
===

Here's some enticing misdirection:

    Download Go tarball: https://golang.org/dl/
    $ tar -C /usr/local -xzf go$VERSION.$OS-$ARCH.tar.gz

I like using ~/code as my $GOHOME.

    $ mkdir -p /home/:your_username/code/


You need to add some stuff to your ~/.bashrc file (or ~/.profile)

    $ export GOROOT=/usr/local/go
    $ export GOARCH=amd64
    $ export GOOS=linux
    $ export GOHOME=/home/:your_username/code/
    $ export PATH=$PATH:/usr/local/go/bin

We use glide to manage our dependencies

    $ brew install glide
    $ go get github.com/sgotti/glide-vc

In case things aren't in $PATH, reload terminal from .bashrc (or ~/.profile)

    $ source ~/.bashrc

Clone TMI into your GOPATH

    $ go get code.justin.tv/chat/tmi

Install some dependencies, and packages you'll want.

    $ sudo apt-get install nginx postgresql build-essential gcc curl redis-server ssh-agent ruby-foreman wscat (some may already be installed)

More things you will want down the line:
    $ sudo apt-get install awscli ansible

Install some miscellaneous things for CRs and such:

    $ sudo apt-get install arcanist
    $ arc install-certificate (you'll need to set this up)
    $ make go
    $ make test

Vagrant
===

```bash
vagrant up
vagrant ssh
cd /go/src/code.justin.tv/chat/tmi
make env
make go
make test
foreman start
```
