package tmi

import (
	"context"
	"encoding/json"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/foundation/twitchclient"

	. "github.com/smartystreets/goconvey/convey"
)

func TestBanUser(t *testing.T) {
	Convey("when calling BanUser", t, func() {
		ctx := context.Background()
		channelID := "123"
		userID := "456"

		Convey("when the backend is available", func() {
			respCode := map[string]interface{}{
				"response_code": "ban_success",
			}

			ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
				w.WriteHeader(http.StatusOK)
				json.NewEncoder(w).Encode(respCode)
			}))
			defer ts.Close()

			c, err := NewClient(twitchclient.ClientConf{
				Host: ts.URL,
			})
			So(err, ShouldBeNil)
			So(c, ShouldNotBeNil)

			resp, err := c.BanUser(ctx, channelID, userID, channelID, nil, nil)
			So(err, ShouldBeNil)
			So(resp, ShouldEqual, "ban_success")
		})

		Convey("when the backend is ded", func() {
			respCode := map[string]interface{}{
				"response_code": "bad_ban_error",
			}

			ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
				w.WriteHeader(http.StatusInternalServerError)
				json.NewEncoder(w).Encode(respCode)
			}))
			defer ts.Close()

			c, err := NewClient(twitchclient.ClientConf{
				Host: ts.URL,
			})
			So(err, ShouldBeNil)
			So(c, ShouldNotBeNil)

			resp, err := c.BanUser(ctx, channelID, userID, channelID, nil, nil)
			So(err, ShouldNotBeNil)
			So(resp, ShouldEqual, "bad_ban_error")
		})
	})
}
