package tmi

import (
	"context"
	"encoding/json"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/foundation/twitchclient"

	. "github.com/smartystreets/goconvey/convey"
)

func TestGetUserEmoteSets(t *testing.T) {
	Convey("when calling GetUserEmoteSets", t, func() {
		ctx := context.Background()
		userID := "supyo"

		Convey("when the backend is available", func() {
			properties := map[string]interface{}{
				"emote_set_ids": []int{1337, 42},
			}

			ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
				json.NewEncoder(w).Encode(properties)
			}))
			defer ts.Close()

			c, err := NewClient(twitchclient.ClientConf{
				Host: ts.URL,
			})
			So(err, ShouldBeNil)
			So(c, ShouldNotBeNil)

			emoteSets, err := c.GetUserEmoteSets(ctx, userID, nil)
			So(err, ShouldBeNil)
			So(emoteSets.SetIDs, ShouldResemble, properties["emote_set_ids"])
		})

		Convey("when the backend is ded", func() {
			ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
				w.WriteHeader(http.StatusInternalServerError)
			}))
			defer ts.Close()

			c, err := NewClient(twitchclient.ClientConf{
				Host: ts.URL,
			})
			So(err, ShouldBeNil)
			So(c, ShouldNotBeNil)

			emoteSets, err := c.GetUserEmoteSets(ctx, userID, nil)
			So(err, ShouldNotBeNil)
			So(emoteSets, ShouldBeNil)
		})
	})
}
