#!/bin/bash

# how many cores do we have?
# the edge server needs to take an appropriate number of cores
cores=$(python -c 'import multiprocessing ; print multiprocessing.cpu_count()' 2>/dev/null)
if [[ $? -ne 0 ]] ; then
    # problem getting cpu count ... fall back to something reasonable
    cores=1
fi

case "$cores" in
    16)
        MAXPROCS=2
        case "$IRC_PORT" in
            80)     MAXPROCS=6 ;;
            443)    MAXPROCS=6 ;;
        esac
        ;;

    32)
        MAXPROCS=2
        case "$IRC_PORT" in
            80)     MAXPROCS=11 ;;
            443)    MAXPROCS=11 ;;
        esac
        ;;

    *)
        # we don't recognize this server size ... don't use multiple cores
        #
        # if this is a dev environment, it'll be easier to debug a single process
        # and if this is a new server size, it'll be clearer what's wrong
        MAXPROCS=1
        echo "this machine appears to have $cores core(s)"
        echo "setting MAXPROCS=$MAXPROCS"
        ;;
esac

export MAXPROCS

# ensure we have an api url if something else didn't set this for us
if [[ -z "$RAILS_API_SERVER" ]]; then
    export RAILS_API_SERVER=localhost:4040
fi

if [[ -z "$RAILS_API_SCHEME" ]]; then
    export RAILS_API_SCHEME=http
fi

if [[ -z "$STATSD_SAMPLE_RATE" ]]; then
    export STATSD_SAMPLE_RATE=0.05
fi

# if we're running the room server, we're allowed to use multiple cores
if [[ -n "$ROOM_PORT" ]]; then
    export GOMAXPROCS=6
fi

# if we're running the pubsub server, we're allowed to use multiple cores
if [[ -n "$PUBSUB_PORT" ]]; then
    export GOMAXPROCS=4
fi

# if we're running the http_edge server, we're allowed to use multiple cores
if [[ -n "$HTTP_EDGE_PORT" ]]; then
    export GOMAXPROCS=4
fi
