job {
  name 'chat-tmi'
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string('GITHUB_ACCESS_TOKEN', 'devtools-deployment-github-api-token')
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
    }
  }
  scm {
    git {
      remote {
        github 'chat/tmi', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy'
    saveDeployArtifact 'chat/tmi', '.manta'
  }
  // Automatically deploy to integration testing environments.
  publishers {
    postBuildScripts {
      steps {
        conditionalSteps {
          condition { stringsMatch('\$GIT_BRANCH', 'origin/master', false) }
          steps {
            shell "AUTO_DEPLOY_ENV=deploy-clue-integration-aws ./scripts/autodeploy.sh"
            shell "AUTO_DEPLOY_ENV=deploy-http-edge-integration-aws ./scripts/autodeploy.sh"
            shell "AUTO_DEPLOY_ENV=deploy-irc-integration-aws ./scripts/autodeploy.sh"
            shell "AUTO_DEPLOY_ENV=deploy-room-integration-aws ./scripts/autodeploy.sh"
            shell "AUTO_DEPLOY_ENV=deploy-tmi-pubsub-integration-aws ./scripts/autodeploy.sh"
          }
        }
      }
    }
  }
}

job {
  name 'chat-tmi-coverage'
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string('GITHUB_ACCESS_TOKEN', 'devtools-deployment-github-api-token')
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
    }
    environmentVariables {
			env('GIT_BRANCH', '${GIT_BRANCH}')
			env('GIT_COMMIT', '${GIT_COMMIT}')
			env('GIT_URL', '${GIT_URL}')
		}
  }
  scm {
    git {
      remote {
        github 'chat/tmi', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy -f build-with-coverage.json'
  }
}

job {
  name 'chat-tmi-deploy'
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo "chat/tmi" --dir "/home/jtv/tmi_deploy"'
  }
}

job {
  name 'chat-tmi-deploy-staging'
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo "chat/tmi" --dir "/home/jtv/twitch_staging_tmi_deploy"'
  }
}
