// Code generated by protoc-gen-go.
// source: room.proto
// DO NOT EDIT!

/*
Package tmi is a generated protocol buffer package.

It is generated from these files:
	room.proto

It has these top-level messages:
	RoomPatchSet
	RoomPatchStatusSet
	MemberListRequestSet
	MemberListUpdateSet
	SpecialUser
	SpecialUserListRequestSet
	SpecialUserListSet
*/
package tmi

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// Edge servers tell the Room servers about clients they own
type RoomPatchSet struct {
	// Edge server identifies itself so the Room server can track its liveness
	EdgeId           *string                   `protobuf:"bytes,1,req,name=edge_id" json:"edge_id,omitempty"`
	Update           []*RoomPatchSet_RoomPatch `protobuf:"bytes,2,rep,name=update" json:"update,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *RoomPatchSet) Reset()         { *m = RoomPatchSet{} }
func (m *RoomPatchSet) String() string { return proto.CompactTextString(m) }
func (*RoomPatchSet) ProtoMessage()    {}

func (m *RoomPatchSet) GetEdgeId() string {
	if m != nil && m.EdgeId != nil {
		return *m.EdgeId
	}
	return ""
}

func (m *RoomPatchSet) GetUpdate() []*RoomPatchSet_RoomPatch {
	if m != nil {
		return m.Update
	}
	return nil
}

type RoomPatchSet_RoomPatch struct {
	Room *string `protobuf:"bytes,1,req,name=room" json:"room,omitempty"`
	// The Edge server asserts the Room server's identity
	Base             *string  `protobuf:"bytes,2,opt,name=base" json:"base,omitempty"`
	Join             []string `protobuf:"bytes,3,rep,name=join" json:"join,omitempty"`
	Part             []string `protobuf:"bytes,4,rep,name=part" json:"part,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *RoomPatchSet_RoomPatch) Reset()         { *m = RoomPatchSet_RoomPatch{} }
func (m *RoomPatchSet_RoomPatch) String() string { return proto.CompactTextString(m) }
func (*RoomPatchSet_RoomPatch) ProtoMessage()    {}

func (m *RoomPatchSet_RoomPatch) GetRoom() string {
	if m != nil && m.Room != nil {
		return *m.Room
	}
	return ""
}

func (m *RoomPatchSet_RoomPatch) GetBase() string {
	if m != nil && m.Base != nil {
		return *m.Base
	}
	return ""
}

func (m *RoomPatchSet_RoomPatch) GetJoin() []string {
	if m != nil {
		return m.Join
	}
	return nil
}

func (m *RoomPatchSet_RoomPatch) GetPart() []string {
	if m != nil {
		return m.Part
	}
	return nil
}

type RoomPatchStatusSet struct {
	Status           []*RoomPatchStatusSet_RoomPatchStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte                                `json:"-"`
}

func (m *RoomPatchStatusSet) Reset()         { *m = RoomPatchStatusSet{} }
func (m *RoomPatchStatusSet) String() string { return proto.CompactTextString(m) }
func (*RoomPatchStatusSet) ProtoMessage()    {}

func (m *RoomPatchStatusSet) GetStatus() []*RoomPatchStatusSet_RoomPatchStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type RoomPatchStatusSet_RoomPatchStatus struct {
	Room *string `protobuf:"bytes,1,req,name=room" json:"room,omitempty"`
	// The Room server doesn't have the context the Edge server expected
	BaseMismatch *bool `protobuf:"varint,2,opt,name=base_mismatch,def=0" json:"base_mismatch,omitempty"`
	// The Room server announces what context it has
	Base             *string `protobuf:"bytes,3,opt,name=base" json:"base,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RoomPatchStatusSet_RoomPatchStatus) Reset()         { *m = RoomPatchStatusSet_RoomPatchStatus{} }
func (m *RoomPatchStatusSet_RoomPatchStatus) String() string { return proto.CompactTextString(m) }
func (*RoomPatchStatusSet_RoomPatchStatus) ProtoMessage()    {}

const Default_RoomPatchStatusSet_RoomPatchStatus_BaseMismatch bool = false

func (m *RoomPatchStatusSet_RoomPatchStatus) GetRoom() string {
	if m != nil && m.Room != nil {
		return *m.Room
	}
	return ""
}

func (m *RoomPatchStatusSet_RoomPatchStatus) GetBaseMismatch() bool {
	if m != nil && m.BaseMismatch != nil {
		return *m.BaseMismatch
	}
	return Default_RoomPatchStatusSet_RoomPatchStatus_BaseMismatch
}

func (m *RoomPatchStatusSet_RoomPatchStatus) GetBase() string {
	if m != nil && m.Base != nil {
		return *m.Base
	}
	return ""
}

// Edge servers ask the Room server for updated room membership
type MemberListRequestSet struct {
	// The Edge server can ask for any number of updates in one request
	Request          []*MemberListRequestSet_MemberListRequest `protobuf:"bytes,1,rep,name=request" json:"request,omitempty"`
	XXX_unrecognized []byte                                    `json:"-"`
}

func (m *MemberListRequestSet) Reset()         { *m = MemberListRequestSet{} }
func (m *MemberListRequestSet) String() string { return proto.CompactTextString(m) }
func (*MemberListRequestSet) ProtoMessage()    {}

func (m *MemberListRequestSet) GetRequest() []*MemberListRequestSet_MemberListRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

type MemberListRequestSet_MemberListRequest struct {
	// The Edge server is interested in an update to this room
	Room *string `protobuf:"bytes,1,req,name=room" json:"room,omitempty"`
	// If the Room server remembers the base version, it should send a patch update
	Base             *string `protobuf:"bytes,2,opt,name=base" json:"base,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *MemberListRequestSet_MemberListRequest) Reset() {
	*m = MemberListRequestSet_MemberListRequest{}
}
func (m *MemberListRequestSet_MemberListRequest) String() string { return proto.CompactTextString(m) }
func (*MemberListRequestSet_MemberListRequest) ProtoMessage()    {}

func (m *MemberListRequestSet_MemberListRequest) GetRoom() string {
	if m != nil && m.Room != nil {
		return *m.Room
	}
	return ""
}

func (m *MemberListRequestSet_MemberListRequest) GetBase() string {
	if m != nil && m.Base != nil {
		return *m.Base
	}
	return ""
}

// The Room server tells the Edge server about updates to room membership
type MemberListUpdateSet struct {
	// The Room server can send any number of updates in one request
	Update           []*MemberListUpdateSet_MemberListUpdate `protobuf:"bytes,1,rep,name=update" json:"update,omitempty"`
	XXX_unrecognized []byte                                  `json:"-"`
}

func (m *MemberListUpdateSet) Reset()         { *m = MemberListUpdateSet{} }
func (m *MemberListUpdateSet) String() string { return proto.CompactTextString(m) }
func (*MemberListUpdateSet) ProtoMessage()    {}

func (m *MemberListUpdateSet) GetUpdate() []*MemberListUpdateSet_MemberListUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

type MemberListUpdateSet_MemberListUpdate struct {
	Room *string `protobuf:"bytes,1,req,name=room" json:"room,omitempty"`
	// The Room server remembers the base - this is a patch update
	Base *string `protobuf:"bytes,2,opt,name=base" json:"base,omitempty"`
	// The Room server supports patch updates - this is the new version identifier
	Newbase          *string        `protobuf:"bytes,3,opt,name=newbase" json:"newbase,omitempty"`
	Join             []string       `protobuf:"bytes,4,rep,name=join" json:"join,omitempty"`
	Part             []string       `protobuf:"bytes,5,rep,name=part" json:"part,omitempty"`
	SpecialUser      []*SpecialUser `protobuf:"bytes,6,rep,name=special_user" json:"special_user,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *MemberListUpdateSet_MemberListUpdate) Reset()         { *m = MemberListUpdateSet_MemberListUpdate{} }
func (m *MemberListUpdateSet_MemberListUpdate) String() string { return proto.CompactTextString(m) }
func (*MemberListUpdateSet_MemberListUpdate) ProtoMessage()    {}

func (m *MemberListUpdateSet_MemberListUpdate) GetRoom() string {
	if m != nil && m.Room != nil {
		return *m.Room
	}
	return ""
}

func (m *MemberListUpdateSet_MemberListUpdate) GetBase() string {
	if m != nil && m.Base != nil {
		return *m.Base
	}
	return ""
}

func (m *MemberListUpdateSet_MemberListUpdate) GetNewbase() string {
	if m != nil && m.Newbase != nil {
		return *m.Newbase
	}
	return ""
}

func (m *MemberListUpdateSet_MemberListUpdate) GetJoin() []string {
	if m != nil {
		return m.Join
	}
	return nil
}

func (m *MemberListUpdateSet_MemberListUpdate) GetPart() []string {
	if m != nil {
		return m.Part
	}
	return nil
}

func (m *MemberListUpdateSet_MemberListUpdate) GetSpecialUser() []*SpecialUser {
	if m != nil {
		return m.SpecialUser
	}
	return nil
}

// Some users are special, and get mentioned as 'staff' or
// get an '@' in front of their nick
type SpecialUser struct {
	Nick *string `protobuf:"bytes,1,req,name=nick" json:"nick,omitempty"`
	// single character to put in front of the user's nick (i.e. '@')
	Prefix *string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	// single word of specialness (i.e. 'staff')
	Specialness      []string `protobuf:"bytes,3,rep,name=specialness" json:"specialness,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *SpecialUser) Reset()         { *m = SpecialUser{} }
func (m *SpecialUser) String() string { return proto.CompactTextString(m) }
func (*SpecialUser) ProtoMessage()    {}

func (m *SpecialUser) GetNick() string {
	if m != nil && m.Nick != nil {
		return *m.Nick
	}
	return ""
}

func (m *SpecialUser) GetPrefix() string {
	if m != nil && m.Prefix != nil {
		return *m.Prefix
	}
	return ""
}

func (m *SpecialUser) GetSpecialness() []string {
	if m != nil {
		return m.Specialness
	}
	return nil
}

// Room server asks Clue server for list of users with Special Powers
type SpecialUserListRequestSet struct {
	Room             []string `protobuf:"bytes,1,rep,name=room" json:"room,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *SpecialUserListRequestSet) Reset()         { *m = SpecialUserListRequestSet{} }
func (m *SpecialUserListRequestSet) String() string { return proto.CompactTextString(m) }
func (*SpecialUserListRequestSet) ProtoMessage()    {}

func (m *SpecialUserListRequestSet) GetRoom() []string {
	if m != nil {
		return m.Room
	}
	return nil
}

// Clue server tells Room server about list of users with Special Powers
type SpecialUserListSet struct {
	SpecialUserList  []*SpecialUserListSet_SpecialUserList `protobuf:"bytes,1,rep,name=special_user_list" json:"special_user_list,omitempty"`
	XXX_unrecognized []byte                                `json:"-"`
}

func (m *SpecialUserListSet) Reset()         { *m = SpecialUserListSet{} }
func (m *SpecialUserListSet) String() string { return proto.CompactTextString(m) }
func (*SpecialUserListSet) ProtoMessage()    {}

func (m *SpecialUserListSet) GetSpecialUserList() []*SpecialUserListSet_SpecialUserList {
	if m != nil {
		return m.SpecialUserList
	}
	return nil
}

type SpecialUserListSet_SpecialUserList struct {
	// this list is scoped to the room (mods), or globally applicable (staff)
	Room             *string        `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
	SpecialUser      []*SpecialUser `protobuf:"bytes,2,rep,name=special_user" json:"special_user,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *SpecialUserListSet_SpecialUserList) Reset()         { *m = SpecialUserListSet_SpecialUserList{} }
func (m *SpecialUserListSet_SpecialUserList) String() string { return proto.CompactTextString(m) }
func (*SpecialUserListSet_SpecialUserList) ProtoMessage()    {}

func (m *SpecialUserListSet_SpecialUserList) GetRoom() string {
	if m != nil && m.Room != nil {
		return *m.Room
	}
	return ""
}

func (m *SpecialUserListSet_SpecialUserList) GetSpecialUser() []*SpecialUser {
	if m != nil {
		return m.SpecialUser
	}
	return nil
}
