# Zuma

Zuma aims to be the root in the system dependency tree powering Community features.
It manages Community-specific data and features that are (or might be) shared between
disparate products.

- [Messaging as a Platform (MaaP) API Spec](docs/maap_api.md)

In addition, this platform also provides access to Moderation Tools products, such as
spam classification and AutoMod. Currently, these are provided through the `maap/extraction` endpoint, and by proxy via
the `ExtractMessage` method in the Zuma Client.

If you have or anticipate a spam/moderation need which these tools cannot solve, please proactively contact the
Moderation Tools team.

## Dependencies

Zuma uses Glide(https://glide.sh/) to manage its vendored dependencies.

## Development

- `make develop` will start a development server listening on port 9001. It will automatically
  restart every time a file changes.

- `make test` will run goconvey against the application. Tests will re-run automatically
  when a file changes.

- `make setup_osx` will attempt to install local development dependencies for an
  OSX environment.

## Cartman auth

To fake cartman auth when developing locally, add a header to your request:

```
Twitch-Authorization: <json blob>
```
where `<json blob>` is of the form:
```
{
"sub": "user id",
"capabilities":
  {
    "capability_name": {"key": "value", "key": "value"},
    "capability_name": {"key": "value", "key": "value"},
    ...
  }
}
```
