package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/backend"
)

func (h *handlers) DeleteMessage(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.DeleteMessageRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateDeleteMessageParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	deleteMessageParams := backend.DeleteMessageParams{
		DeletedAt: h.Backend.TimeNow(),
	}
	message, err := h.Backend.DeleteMessage(ctx, params.MessageID, params.DeleterID, deleteMessageParams)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	}

	resp := api.DeleteMessageResponse{
		Message: exportMessage(message),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateDeleteMessageParams(params api.DeleteMessageRequest) error {
	if params.MessageID == "" {
		return errx.New("message ID is invalid")
	}

	if params.DeleterID == "" {
		return errx.New("deleter user ID is invalid")
	}

	return nil
}
