package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/backend"
)

func (h *handlers) EditMessage(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.EditMessageRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateEditMessageParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	content := importMessageContent(params.Content)
	updateParams := backend.UpdateMessageParams{
		Content:   &content,
		UpdatedAt: h.Backend.TimeNow(),
	}
	message, err := h.Backend.UpdateMessage(ctx, params.MessageID, params.EditorID, updateParams)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	}

	resp := api.EditMessageResponse{
		Message: exportMessage(message),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateEditMessageParams(params api.EditMessageRequest) error {
	if params.MessageID == "" {
		return errx.New("message ID is invalid")
	}

	if params.EditorID == "" {
		return errx.New("editor user ID is invalid")
	}

	if len(params.Content.Text) == 0 {
		return errx.New("message text is invalid")
	}

	return nil
}
