package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/internal/models"
)

func (h *handlers) GetContainer(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.GetContainerRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateGetContainerParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	c := models.Entity{params.ContainerEntity}
	container, err := h.Backend.GetContainer(ctx, c)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	} else if container == nil {
		// If container does not exist, use a default container.
		container = &models.Container{
			ContainerEntity: c,
			RequireReview:   models.RequireReviewNone,
		}
	}

	resp := api.GetContainerResponse{
		Container: exportContainer(*container),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateGetContainerParams(params api.GetContainerRequest) error {
	if params.ContainerEntity.ID() == "" {
		return errx.New("container is invalid")
	}

	return nil
}
