package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/internal/models"
)

func (h *handlers) GetContainerView(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.GetContainerViewRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateGetContainerViewParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	containerView, err := h.Backend.GetContainerView(ctx, params.UserID, models.Entity{params.ContainerEntity})
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	} else if containerView == nil {
		err := errx.New("user does not have a container view")
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusNotFound)
		return
	}

	resp := api.GetContainerViewResponse{
		ContainerView: exportContainerView(*containerView),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateGetContainerViewParams(params api.GetContainerViewRequest) error {
	if params.UserID == "" {
		return errx.New("user ID is invalid")
	}

	if params.ContainerEntity.ID() == "" {
		return errx.New("container is invalid")
	}

	return nil
}
