package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/internal/models"
)

func (h *handlers) GetMember(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.GetMemberRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateGetMemberParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	containerView, err := h.Backend.GetContainerView(ctx, params.UserID, models.Entity{params.ContainerEntity})
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	} else if containerView == nil {
		err := errx.New("user is not a member of this container")
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusNotFound)
		return
	}

	resp := api.GetMemberResponse{
		UserID:          containerView.UserID,
		ContainerEntity: containerView.ContainerEntity.Entity,
		JoinedAt:        containerView.JoinedAt,
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateGetMemberParams(params api.GetMemberRequest) error {
	if params.ContainerEntity.ID() == "" {
		return errx.New("container ID is invalid")
	}

	if params.UserID == "" {
		return errx.New("user ID is invalid")
	}

	return nil
}
