package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
)

func (h *handlers) GetMessage(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.GetMessageRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateGetMessageParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	message, err := h.Backend.GetMessage(ctx, params.MessageID)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	} else if message == nil {
		err := errx.New("message not found")
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusNotFound)
		return
	}

	resp := api.GetMessageResponse{
		Message: exportMessage(*message),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateGetMessageParams(params api.GetMessageRequest) error {
	if params.MessageID == "" {
		return errx.New("message ID is invalid")
	}

	return nil
}
