package app

import (
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/internal/models"
)

// Methods in this file convert external, exported structs that are part of the
// public interface into internal, backend structs.

// importMessageContentEmoticons assembles a slice of internal "MessageContentEmoticon" objects.
func importMessageContentEmoticons(emoticons []api.MessageContentEmoticon) []models.MessageContentEmoticon {
	res := []models.MessageContentEmoticon{}
	for _, e := range emoticons {
		res = append(res, models.MessageContentEmoticon(e))
	}
	return res
}

// importUserBadges assembles a slice of internal "UserBadge" objects.
func importUserBadges(badges []api.UserBadge) []models.UserBadge {
	res := []models.UserBadge{}
	for _, b := range badges {
		res = append(res, models.UserBadge(b))
	}
	return res
}

// importMessageContent assembles an internal "MessageContent" object.
func importMessageContent(mc api.MessageContent) models.MessageContent {
	return models.MessageContent{
		Text:      mc.Text,
		Emoticons: importMessageContentEmoticons(mc.Emoticons),
	}
}

// importMessageSender assembles the "Sender" field in the extract response.
func importMessageSender(ms api.MessageSender) models.MessageSender {
	return models.MessageSender{
		UserID:      ms.UserID,
		Login:       ms.Login,
		DisplayName: ms.DisplayName,
		ChatColor:   ms.ChatColor,
		Badges:      importUserBadges(ms.Badges),
	}
}
