package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/backend"
)

func (h *handlers) RejectMessage(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.RejectMessageRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateRejectMessageParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	// A rejected message is unpublished and marked as no longer requiring review.
	isPublished := false
	isPendingReview := false
	updateParams := backend.UpdateMessageParams{
		IsPublished:     &isPublished,
		IsPendingReview: &isPendingReview,
		UpdatedAt:       h.Backend.TimeNow(),
	}
	m, err := h.Backend.UpdateMessage(ctx, params.MessageID, params.RejecterID, updateParams)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	}

	resp := api.RejectMessageResponse{
		Message: exportMessage(m),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateRejectMessageParams(params api.RejectMessageRequest) error {
	if params.MessageID == "" {
		return errx.New("message ID is invalid")
	}

	if params.RejecterID == "" {
		return errx.New("rejecter user ID is invalid")
	}

	return nil
}
